// // // // // // // // // // // // //
//
//	Ebene
//
//	erstellt 27.12.97 von Andreas Warnke
//	geändert 12.5.98 von Andreas Warnke
//



#ifndef Ebene_h___
#define Ebene_h___



// // // // // // // // // // // // //
//
//	include
//

#include <View.h>
#include <Handler.h>
#include <Bitmap.h>
#include "Ebene.h"
#include "ClientWelt.h"
class ClientWelt;
#include "Objekt.h"



// // // // // // // // // // // // //
//
//	Konstanten
//

#define _Ebene_h_Waben_Hoehe 48
#define _Ebene_h_Waben_Faktor 0.8660254	//	cos ( PI/6 ) = 0.8660254
#define _Ebene_h_Waben_Breite int ( _Ebene_h_Waben_Faktor * _Ebene_h_Waben_Hoehe )
#define _Ebene_h_Karten_Rand ( _Ebene_h_Waben_Hoehe / 2 )
#define _Ebene_h_Waben_dy int ( _Ebene_h_Waben_Hoehe * 0.75 )
#define _Ebene_h_Objekt_Hoehe ( _Ebene_h_Waben_Hoehe / 2 )
#define _Ebene_h_Objekt_Breite _Ebene_h_Objekt_Hoehe
#define _Ebene_h_Objekt_Rand_X (( _Ebene_h_Waben_Breite - _Ebene_h_Objekt_Breite ) / 2 )
#define _Ebene_h_Objekt_Rand_Y (( _Ebene_h_Waben_Hoehe - _Ebene_h_Objekt_Hoehe ) / 2 )
enum { eEnableBuildingCities = 0 };



// // // // // // // // // // // // //
//
//	Ebene:
//

class Ebene : public BView
{
private:
	//	inherited:
	typedef BView inherited;

	//	Zeiger auf die ScrollView:
	BScrollView * DerScroller;
	
	//	Karte
	ClientWelt * DieWelt;
	
	//	letzte gecheckte Mausposition:
	int MausX;
	int MausY;
	//	Scrolling-Einstellungen:
	BPoint DragMapPos;
	bool DragMap;
	bool AutoScroll;
	bool ScrollToStartPosition;
	
	//	Mein Name und Passwort:
	char * DerName;
	char * DasPasswort;
	
private:	
	//	Datenabgleich mit Server.
	//
	
	//	GetStatusMessage:
	void GetStatus ( BMessage * inMessage);

	//	Funktionen, um Karte und Figuren zu verwalten.
	//
	
	//	InitEbene
	void InitEbene ( BMessage * inMessage );

	//	Funktionen für die Grafik-Ausgabe:
	//
	
	//	DrawField (Voraussetzung: korrekte Clipping - Region):
	void DrawField ( int inXCoord, int inYCoord);
	
	//	AdjustScrollBars();
	void AdjustScrollBars();
	
	//	PopUp
	BPopUpMenu * CreatePopUp ( int inInfoX, int inInfoY, unsigned int inBuildID );
	
	//	ScrollBy
	void ScrollBy ( float inDx, float inDy );
	void ScrollTo ( BPoint inLeftTop );
	
	//	CelebrateVictory
	void CelebrateVictory ( unsigned int inID, const char * inName );
	
public:
	//	Konstruktor
	Ebene (
		BRect inRect,
		const char * inName,
		const char * inPassword);
	
	//	Destruktor
	virtual ~Ebene ();
	
	//	Initialisieren des Scrollers:
	void InitScroller ( BScrollView * inView );
	
	//	Fenstergröße geändert:
	virtual void FrameResized ( float inWidth, float inHeight );
	
	//	Draw
	virtual void Draw ( BRect inRect );
	
	//	MessageReceived
	virtual void MessageReceived ( BMessage * inMessage );
	
	//	Pulse:
	virtual void Pulse ();
	
	//	MouseMoved
	virtual void MouseMoved (
		BPoint inLocation,
		uint32 inAction,
		const BMessage * inMessage);
	void MouseCursor (
		BPoint inLocation,
		const BMessage * inMessage );
		
	//	MouseDown:
	virtual void MouseDown( BPoint inPos);
	
	//	Umrechnungen zwischen View-Koordinaten und Map-Koordiaten:
	static inline BPoint GetBPoint ( int inXCoord, int inYCoord);
	static inline BRect GetBRect ( int inXCoord, int inYCoord);
	static void GetMapLocation ( float inX, float inY, int & outX, int & outY );

	//	Fehlerausgabe-Prozedur
	void ErrorAlert ( const char * inText );
};



#endif



//
//	Ende
//
// // // // // // // // // // // // //